function onLoad() {
    if (g_form.isNewRecord()) {
        return;
    }
    var tableName = g_form.getTableName();
    var ajax = new GlideAjax('bpattern_utils');
    ajax.addParam('sysparm_name', 'getClassDisplayName');
    ajax.addParam('tableName', tableName);

    ajax.getXMLAnswer(function (entityDisplayName) {
        var context = {
            payload: {
                type: 'OPENED_CONTACT',
                data: {
                    contact: {
                        sysId: g_form.getUniqueValue(),
                        recordType: g_form.getTableName(),
                        displayRecordType: entityDisplayName,
                        displayName: g_form.getDisplayValue(),
                        phones: {
                            business: g_form.getValue('phone'),
                            mobile: g_form.getValue('mobile_phone'),
                        },
                        email: g_form.getValue('email'),
                    },
                    task: 'NONE'
                }
            },
            method: 'openframe_communication'
        };
        CustomEvent.fireAll('openframe_request', context);
    });
}
