function onSubmit() {

    var tableRefs = {
        incident: 'caller_id',
        sn_customerservice_case: 'contact',
        sc_request: 'request_for',
    };

    var tableName = g_form.getTableName();
    var ajax = new GlideAjax('bpattern_utils');
    ajax.addParam('sysparm_name', 'getClassDisplayName');
    ajax.addParam('tableName', tableName);

    ajax.getXMLAnswer(function (entityDisplayName) {

        var context = {
            payload: {
                type: 'SUBMIT_TASK',
                data: {
                    task: {
                        sysId: g_form.getUniqueValue(),
                        recordType: g_form.getTableName(),
                        displayRecordType: entityDisplayName,
                        displayId: g_form.getDisplayValue(),
                        shortDescription: g_form.getValue('short_description'),
                    },
                    contact: 'NONE'
                }
            },
            method: 'openframe_communication'
        };
        if (g_form.getValue(tableRefs[tableName])) {
            g_form.getReference(tableRefs[tableName], function (contactRef) {

                context.payload.data.contact = {
                    sysId: contactRef.sys_id,
                    recordType: contactRef.tableName,
                    displayRecordType: contactRef.tableName,
                    displayName: contactRef.name,
                    phones: {
                        business: contactRef.phone,
                        mobile: contactRef.mobile_phone
                    },
                    email: contactRef.email,
                };
                CustomEvent.fireAll('openframe_request', context);
            });
        } else {
            CustomEvent.fireAll('openframe_request', context);
        }
    });
}
