function bpatternServiceNowProxy() {
    /* widget controller */
    var c = this;

    var ADAPTER_TO_PROXY = {
        SHOW_WIDGET: 'sn_proxy_show_widget',
        SAVE_ACTIVITY: 'sn_proxy_save_activity',
        OPEN_OBJECT: 'sn_proxy_open_object',
        SEARCH_OBJECTS: 'sn_proxy_search_objects',
        OPEN_CUSTOM_URL: 'sn_proxy_open_custom_url',
        GET_KB_FOLDER: 'sn_proxy_get_kb_folder',
        GET_KB_ARTICLE: 'sn_proxy_get_kb_article',
        SEARCH_KB: 'sn_proxy_search_kb',
        REQUEST_OBJECT: 'sn_proxy_request_object',
        CHECK_OBJECTS_EXISTENCE: 'sn_proxy_check_objects_existence',
        GET_CONFIG: 'sn_proxy_get_config'
    };
    var PROXY_TO_ADAPTER = {
        OPENED_TASK: 'sn_proxy_opened_task',
        SUBMIT_TASK: 'sn_proxy_submit_task',
        OPENED_CONTACT: 'sn_proxy_opened_contact',
        SUBMIT_CONTACT: 'sn_proxy_submit_contact',
        URL_CHANGED: 'sn_proxy_url_changed',
        CLICK_TO_CALL: 'sn_proxy_click_to_call',
        ACTIVATION: 'sn_proxy_activation',
        GET_KB_FOLDER_RESULT: 'sn_proxy_get_kb_folder_result',
        GET_KB_ARTICLE_RESULT: 'sn_proxy_get_kb_article_result',
        SEARCH_KB_RESULT: 'sn_proxy_search_kb_result',
        REQUEST_OBJECT_RESULT: 'sn_proxy_request_object_result',
        CHECK_OBJECTS_EXISTENCE_RESULT: 'sn_proxy_check_objects_existence_result',
        GET_CONFIG_RESULT: 'sn_proxy_get_config_result'
    };
    var PROXY_TO_SERVICENOW = {
        SAVE_ACTIVITY: 'save_activity_history',
        GET_KB_FOLDER: 'get_kb_folder',
        GET_KB_ARTICLE: 'get_kb_article',
        SEARCH_KB: 'search_kb',
        REQUEST_OBJECT: 'request_object',
        CHECK_OBJECTS_EXISTENCE: 'check_objects_existence'
    };

    var lastUrlPath = null;
    var disableSaveActivity = false;
    var openRecordsInNewTab = false;
    var allowEmptyRecordsList = false;

    var initialTitle = window.top.document.title;
    var blinkingTitleValue = 'New screen';
    var titleBlinkingIntervalId = -1;

    function startTitleBlinking() {
        initialTitle = window.top.document.title;
        titleBlinkingIntervalId = setInterval(function () {
            window.top.document.title = window.top.document.title === blinkingTitleValue ? initialTitle : blinkingTitleValue;
        }, 700);
    }

    function stopTitleBlinking() {
        if (titleBlinkingIntervalId === -1) {
            return;
        }
        clearInterval(titleBlinkingIntervalId);
        titleBlinkingIntervalId = -1;
        window.top.document.title = initialTitle;
    }

    function consoleLog() {
        console.log(
            '@@@BP SN Proxy: ',
            JSON.stringify(arguments[0]) || '',
            JSON.stringify(arguments[1]) || '',
            JSON.stringify(arguments[2]) || '',
            JSON.stringify(arguments[3]) || ''
        );
    }
    function consoleError() {
        console.error(
            '@@@BP SN Proxy: ',
            JSON.stringify(arguments[0]) || '',
            JSON.stringify(arguments[1]) || '',
            JSON.stringify(arguments[2]) || '',
            JSON.stringify(arguments[3]) || ''
        );
    }

    function promiseAllSettled(promises) {
        return new Promise(function (resolve) {
            if (!promises.length) {
                return resolve(promises);
            }
            var numberOfResolved = 0;
            var results = [];

            function checkIfAllFulfilled() {
                numberOfResolved++;
                if (numberOfResolved === promises.length) {
                    resolve(results);
                }
            }

            promises.forEach(function (targetPromise, index) {
                targetPromise.then(
                    function (result) {
                        results[index] = {
                            status: 'resolved',
                            value: result
                        };
                        checkIfAllFulfilled();
                    },
                    function (error) {
                        results[index] = {
                            status: 'rejected',
                            value: error
                        };
                        checkIfAllFulfilled();
                    }
                );
            });
        });
    }

    function initializeOpenFrameAPI() {
        return new Promise(function (resolve, reject) {
            window.openFrameAPI.init({},
                function onSuccess(openFrameConfig) {
                    consoleLog('OpenFrame init success, with config:', openFrameConfig);
                    try {
                        var bpConfig = JSON.parse(openFrameConfig.configuration);
                        resolve(bpConfig);
                    } catch (err) {
                        consoleError('OpenFrame configuration parsing failed:', openFrameConfig.configuration);
                        reject(err);
                    }
                },
                function onFail(e) {
                    consoleError('OpenFrame init failed:', e);
                    reject(e);
                }
            );
        });
    }

    function initializeBPAdapter(openFrameConfig) {
        return new Promise(function (resolve, reject) {

            var adapterUrl = openFrameConfig.bpatternAdapterUrl;
            disableSaveActivity = !!openFrameConfig.disableSaveActivity;
            openRecordsInNewTab = !!openFrameConfig.openRecordsInNewTab;
            allowEmptyRecordsList = !!openFrameConfig.allowEmptyRecordsList;

            if (!adapterUrl) {
                reject('"bpatternAdapterUrl" openFrame configuration parameter is not specified!');
                return;
            }
            var bpatternAdapterUrl = (adapterUrl.length > 8 && adapterUrl.slice(0, 8) === 'https://' ? '' : 'https://') + adapterUrl;

            var bpatternAdapterIframe = document.createElement('iframe');
            bpatternAdapterIframe.id = 'bpattern_sn_adapter';
            bpatternAdapterIframe.style.width = '100%';
            bpatternAdapterIframe.style.height = '100%';
            bpatternAdapterIframe.style.border = 'none';
            bpatternAdapterIframe.allow = 'microphone; camera; geolocation';
            bpatternAdapterIframe.src =  bpatternAdapterUrl;

            var frameContainer = document.getElementById('bpattern_iframe_container');
            frameContainer.appendChild(bpatternAdapterIframe);

            setInterval(function () {
                var currentUrlPath = window.top.location.pathname + window.top.location.search;
                if (currentUrlPath === lastUrlPath) {
                    return;
                }
                consoleLog('New URL detected:', currentUrlPath);
                bpatternAdapterIframe.contentWindow.postMessage({
                    type: PROXY_TO_ADAPTER.URL_CHANGED,
                    data: {
                        url: currentUrlPath,
                    }
                }, '*');
                lastUrlPath = currentUrlPath;
            }, 300);

            resolve({iframe: bpatternAdapterIframe, url: bpatternAdapterUrl});
        });
    }

    function requestObjectInfo(sysId, tableName) {
        return new Promise(function (resolve, reject) {
            var snObjectRequest = {
                action: PROXY_TO_SERVICENOW.REQUEST_OBJECT,
                data: {
                    sysId: sysId,
                    tableName: tableName,
                }
            };
            consoleLog('RequestSNObject Server Request:', snObjectRequest);
            c.server.get(snObjectRequest).then(function (result) {
                consoleLog('RequestSNObject Server Response:', result.data);
                if (result.data.result.success) {
                    resolve(result.data.result.recordInfo);
                } else {
                    resolve(null);
                }
            }, reject);
        });
    }

    function setupLogic(bpatternAdapter) {

        /** Subscribe to openFrame Api events */
        window.openFrameAPI.subscribe(
            window.openFrameAPI.EVENTS.COMMUNICATION_EVENT,
            function (context) {

                switch (context.type) {
                    case 'OUTGOING_CALL': {
                        var recordInfoPromises = context.data.data.reduce(function(arr, objectInfo) {
                            var match = objectInfo.query.match(/sys_id=([0-9a-f]+)(?:&|$)/);
                            if (match) {
                                arr.push(requestObjectInfo(match[1], objectInfo.entity));
                            }
                            return arr;
                        }, []);
                        window.openFrameAPI.show();
                        promiseAllSettled(recordInfoPromises)
                            .then(function (results) {
                                return results.reduce(function (arr, promiseResult) {
                                    if (promiseResult.status === 'resolved') {
                                        arr.push(promiseResult.value);
                                    }
                                    return arr;
                                }, []);
                            })
                            .then(function (records) {
                                var validRecords = records.filter(function (record) {
                                    return !!record && record.refType !== 'other';
                                });
                                consoleLog('Click-to-call context:', context);
                                consoleLog('Click-to-call associated records:', validRecords);
                                bpatternAdapter.iframe.contentWindow.postMessage({
                                    type: PROXY_TO_ADAPTER.CLICK_TO_CALL,
                                    data: {
                                        phone: context.data.metaData.phoneNumber,
                                        records: validRecords
                                    }
                                }, '*');
                            });
                        break;
                    }
                    case 'OPENED_TASK': {
                        consoleLog('Task opened:', context.data);
                        bpatternAdapter.iframe.contentWindow.postMessage({
                            type: PROXY_TO_ADAPTER.OPENED_TASK,
                            data: context.data
                        }, '*');
                        break;
                    }
                    case 'SUBMIT_TASK': {
                        consoleLog('Task submitted:', context.data);
                        bpatternAdapter.iframe.contentWindow.postMessage({
                            type: PROXY_TO_ADAPTER.SUBMIT_TASK,
                            data: context.data
                        }, '*');
                        break;
                    }
                    case 'OPENED_CONTACT': {
                        consoleLog('Contact opened:', context.data);
                        bpatternAdapter.iframe.contentWindow.postMessage({
                            type: PROXY_TO_ADAPTER.OPENED_CONTACT,
                            data: context.data
                        }, '*');
                        break;
                    }
                    case 'SUBMIT_CONTACT': {
                        consoleLog('Contact submitted:', context.data);
                        bpatternAdapter.iframe.contentWindow.postMessage({
                            type: PROXY_TO_ADAPTER.SUBMIT_CONTACT,
                            data: context.data
                        }, '*');
                        break;
                    }
                }
            }
        );

        /** Subscribe to BP Adapter events */
        window.addEventListener('message', function (e) {
            var bpatternUrl = new URL(bpatternAdapter.url);
            if (e.data && e.origin === bpatternUrl.origin) {
                switch (e.data.type) {

                    case ADAPTER_TO_PROXY.SHOW_WIDGET: {
                        window.openFrameAPI.show();
                        break;
                    }
                    case ADAPTER_TO_PROXY.OPEN_OBJECT: {
                        consoleLog('Screen pop handler:', e.data.data);
                        var options = e.data.data.options;
                        if (options.inNewTab || (options.source === 'user' && openRecordsInNewTab)) {
                            window.open(
                                window.top.location.origin + '/nav_to.do?uri=' + encodeURIComponent('/' + e.data.data.recordType + '.do?sys_id=' + e.data.data.sysId),
                                '_blank',
                                ''
                            );
                            break;
                        }
                        window.openFrameAPI.openServiceNowForm({
                            entity: e.data.data.recordType,
                            query: 'sys_id=' + e.data.data.sysId
                        });
                        if (window.top.document.visibilityState !== 'visible') {
                            startTitleBlinking();
                        }
                        break;
                    }
                    case ADAPTER_TO_PROXY.SEARCH_OBJECTS: {
                        consoleLog('Screen pop search handler:', e.data.data);
                        if (e.data.data.inNewTab) {
                            window.open(
                                window.top.location.origin + '/nav_to.do?uri=%2F' + e.data.data.recordType + '_list.do%3F' + encodeURIComponent('sysparm_query=' + encodeURIComponent(e.data.data.query)),
                                '_blank',
                                ''
                            );
                            break;
                        }
                        window.openFrameAPI.openServiceNowList({
                            entity: e.data.data.recordType,
                            query: e.data.data.query
                        });
                        if (window.top.document.visibilityState !== 'visible') {
                            startTitleBlinking();
                        }
                        break;
                    }
                    case ADAPTER_TO_PROXY.SAVE_ACTIVITY: {
                        if (disableSaveActivity) {
                            consoleLog('Save Activity cancelled: client auto save disabled');
                            break;
                        }
                        var activityRequest = {
                            action: PROXY_TO_SERVICENOW.SAVE_ACTIVITY,
                            data: e.data.data.activity
                        };
                        consoleLog('SaveActivityHistory Server Request:', activityRequest);
                        c.server.get(activityRequest).then(function (result) {
                            consoleLog('SaveActivityHistory Server Response:', result.data);
                        });
                        break;
                    }
                    case ADAPTER_TO_PROXY.OPEN_CUSTOM_URL: {
                        consoleLog('Switch URL to', e.data.data.url);
                        window.openFrameAPI.openCustomURL(e.data.data.url);
                        break;
                    }
                    case ADAPTER_TO_PROXY.GET_KB_FOLDER: {
                        var getKbFolderRequest = {
                            action: PROXY_TO_SERVICENOW.GET_KB_FOLDER,
                            data: e.data.data.options
                        };
                        consoleLog('GetKBFolder Server Request:', getKbFolderRequest);
                        c.server.get(getKbFolderRequest).then(function (result) {
                            consoleLog('GetKBFolder Server Response:', result.data);
                            bpatternAdapter.iframe.contentWindow.postMessage({
                                type: PROXY_TO_ADAPTER.GET_KB_FOLDER_RESULT,
                                data: {
                                    requestId: e.data.data.requestId,
                                    result: result.data.result.success
                                        ? result.data.result.results
                                        : []
                                }
                            }, '*');
                        });
                        break;
                    }
                    case ADAPTER_TO_PROXY.SEARCH_KB: {
                        var searchKbRequest = {
                            action: PROXY_TO_SERVICENOW.SEARCH_KB,
                            data: e.data.data.options
                        };
                        consoleLog('SearchKB Server Request:', searchKbRequest);
                        c.server.get(searchKbRequest).then(function (result) {
                            consoleLog('SearchKB Server Response:', result.data);
                            bpatternAdapter.iframe.contentWindow.postMessage({
                                type: PROXY_TO_ADAPTER.SEARCH_KB_RESULT,
                                data: {
                                    requestId: e.data.data.requestId,
                                    result: result.data.result.success
                                        ? result.data.result.results
                                        : []
                                }
                            }, '*');
                        });
                        break;
                    }
                    case ADAPTER_TO_PROXY.GET_KB_ARTICLE: {
                        var kbArticleRequest = {
                            action: PROXY_TO_SERVICENOW.GET_KB_ARTICLE,
                            data: {
                                articleId: e.data.data.articleId
                            }
                        };
                        consoleLog('GetKBArticle Server Request:', kbArticleRequest);
                        c.server.get(kbArticleRequest).then(function (result) {
                            consoleLog('GetKBArticle Server Response:', result.data);
                            bpatternAdapter.iframe.contentWindow.postMessage({
                                type: PROXY_TO_ADAPTER.GET_KB_ARTICLE_RESULT,
                                data: {
                                    requestId: e.data.data.requestId,
                                    article: result.data.result.success
                                        ? result.data.result.article
                                        : null
                                }
                            }, '*');
                        });
                        break;
                    }
                    case ADAPTER_TO_PROXY.REQUEST_OBJECT: {
                        requestObjectInfo(
                            e.data.data.sysId,
                            e.data.data.tableName
                        ).then(function (recordInfo) {
                            bpatternAdapter.iframe.contentWindow.postMessage({
                                type: PROXY_TO_ADAPTER.REQUEST_OBJECT_RESULT,
                                data: {
                                    requestId: e.data.data.requestId,
                                    recordInfo: recordInfo
                                }
                            }, '*');
                        });
                        break;
                    }
                    case ADAPTER_TO_PROXY.CHECK_OBJECTS_EXISTENCE: {
                        var snObjectsExistenceRequest = {
                            action: PROXY_TO_SERVICENOW.CHECK_OBJECTS_EXISTENCE,
                            data: {
                                selectedRecords: e.data.data.selectedRecords
                            }
                        };
                        consoleLog('CheckObjectsExistence Server Request:', snObjectsExistenceRequest);
                        c.server.get(snObjectsExistenceRequest).then(function (result) {
                            consoleLog('CheckObjectsExistence Server Response:', result.data);
                            bpatternAdapter.iframe.contentWindow.postMessage({
                                type: PROXY_TO_ADAPTER.CHECK_OBJECTS_EXISTENCE_RESULT,
                                data: {
                                    requestId: e.data.data.requestId,
                                    existenceData: result.data.result.existenceData
                                }
                            }, '*');
                        });
                        break;
                    }
                    case ADAPTER_TO_PROXY.GET_CONFIG: {
                        var snConfig = {
                            allowEmptyRecordsList: allowEmptyRecordsList
                        };
                        consoleLog('SN Config requested:', snConfig);
                        bpatternAdapter.iframe.contentWindow.postMessage({
                            type: PROXY_TO_ADAPTER.GET_CONFIG_RESULT,
                            data: snConfig
                        }, '*');
                        break;
                    }
                }
            }
        });

        /** Subscribe to browser events */
        window.top.addEventListener('visibilitychange', function () {
            if (window.top.document.visibilityState === 'visible') {
                stopTitleBlinking();
                consoleLog('generate ACTIVATION on visibility change');
                bpatternAdapter.iframe.contentWindow.postMessage({
                    type: PROXY_TO_ADAPTER.ACTIVATION,
                    data: {}
                }, '*');
            }
        });
        window.top.addEventListener('focus', function () {
            consoleLog('generate ACTIVATION on focus');
            bpatternAdapter.iframe.contentWindow.postMessage({
                type: PROXY_TO_ADAPTER.ACTIVATION,
                data: {}
            }, '*');
        });
    }

    function start() {
        initializeOpenFrameAPI()
            .then(initializeBPAdapter, consoleError)
            .then(setupLogic, consoleError);
    }

    if (document.readyState === 'complete') {
        start();
    } else {
        window.addEventListener('load', start);
    }
}
