(function () {
    if (!input) {
        return;
    }
    var PROXY_TO_SERVICENOW = {
        SAVE_ACTIVITY: 'save_activity_history',
        GET_KB_FOLDER: 'get_kb_folder',
        GET_KB_ARTICLE: 'get_kb_article',
        SEARCH_KB: 'search_kb',
        REQUEST_OBJECT: 'request_object',
        CHECK_OBJECTS_EXISTENCE: 'check_objects_existence'
    };
    try {
        switch (input.action) {
            case PROXY_TO_SERVICENOW.SAVE_ACTIVITY: {
                var phoneLogRecord = new GlideRecord('sn_openframe_phone_log');
                phoneLogRecord.initialize();

                phoneLogRecord.setValue('call_id', input.data.globalInteractionId);
                phoneLogRecord.setValue('call_type', input.data.direction);
                phoneLogRecord.setValue('start_time', input.data.startTime);
                phoneLogRecord.setValue('end_time', input.data.endTime);
                var duration = new GlideDuration(Number(input.data.duration));
                phoneLogRecord.setValue('duration', duration);
                phoneLogRecord.setValue('phone_number', "+" + input.data.phonenumber);
                phoneLogRecord.setValue('x_bripa_occsn_disposition', input.data.disposition);
                phoneLogRecord.setValue('x_bripa_occsn_notes', input.data.description);
                phoneLogRecord.setValue('x_bripa_occsn_service', input.data.service);
                phoneLogRecord.setValue('x_bripa_occsn_recording_url', input.data.playbackUrl);
                phoneLogRecord.setValue('x_bripa_occsn_global_id', input.data.globalInteractionId);
                phoneLogRecord.setValue('x_bripa_occsn_destination_number', "+" + input.data.dnis);
                phoneLogRecord.setValue('x_bripa_occsn_qm_url', input.data.recordingUrl);
                phoneLogRecord.setValue('recording_url',
                    'Interaction type: ' + input.data.type + '\n' +
                    'Recording URL: ' + input.data.recordingUrl + '\n' +
                    'Service: ' + input.data.service + '\n' +
                    'Disposition: ' + input.data.disposition + '\n' +
                    'Notes: ' + input.data.description + '\n' +
                    'Phone: ' + input.data.phonenumber + '\n'
                );

                if (input.data.taskId) {
                    phoneLogRecord.setValue('task', input.data.taskId);
                }

                if (input.data.contactId) {
                    phoneLogRecord.setValue('contact', input.data.contactId);
                } else {
                    try {
                        var contactRecord = new GlideRecord('sys_user');
                        contactRecord.initialize();
                        var phoneNumber = '+' + input.data.phonenumber;
                        var foundRecord = contactRecord.get('phone', phoneNumber);
                        if (foundRecord) {
                            var contactId = contactRecord.getUniqueValue();
                            phoneLogRecord.setValue('contact', contactId);
                        }
                    } catch (e) { }
                }

                var insertResult = phoneLogRecord.insert();
                data.result = {
                    success: true,
                    insertedValue: insertResult
                };
                break;
            }
            case PROXY_TO_SERVICENOW.SEARCH_KB: {

                var searchKnowledgeGr = new GlideRecord('kb_knowledge');
                searchKnowledgeGr.addQuery('workflow_state', '=', 'published');
                searchKnowledgeGr.addQuery('short_description', 'CONTAINS', input.data.query);
                if (input.data.folderId) {
                    searchKnowledgeGr.addQuery('kb_knowledge_base', '=', input.data.folderId);
                }
                searchKnowledgeGr.query();

                var results = [];
                while (searchKnowledgeGr.next()) {

                    var articleContent = searchKnowledgeGr.getValue('article_type') === 'wiki'
                        ? searchKnowledgeGr.getValue('meta_description') || searchKnowledgeGr.getValue('wiki') || ''
                        : searchKnowledgeGr.getValue('text') || '';

                    results.push({
                        id: searchKnowledgeGr.getValue('sys_id'),
                        type: 'article',
                        title: searchKnowledgeGr.getValue('short_description'),
                        text: articleContent.substring(0, 100)
                    });
                }
                data.result = {
                    success: true,
                    results: results
                };
                break;
            }
            case PROXY_TO_SERVICENOW.GET_KB_FOLDER: {

                var folderContent = [];
                if (input.data.folderId) {
                    var searchKnowledgeGr2 = new GlideRecord('kb_knowledge');
                    searchKnowledgeGr2.addQuery('workflow_state', '=', 'published');
                    searchKnowledgeGr2.addQuery('kb_knowledge_base', '=', input.data.folderId);
                    searchKnowledgeGr2.query();

                    while (searchKnowledgeGr2.next()) {
                        var articleContent2 = searchKnowledgeGr2.getValue('article_type') === 'wiki'
                            ? searchKnowledgeGr2.getValue('meta_description') || searchKnowledgeGr2.getValue('wiki') || ''
                            : searchKnowledgeGr2.getValue('text') || '';

                        folderContent.push({
                            id: searchKnowledgeGr2.getValue('sys_id'),
                            type: 'article',
                            title: searchKnowledgeGr2.getValue('short_description'),
                            text: articleContent2.substring(0, 100)
                        });
                    }

                } else {
                    var knowledgeBasesGr = new GlideRecord('kb_knowledge_base');
                    knowledgeBasesGr.query();

                    while (knowledgeBasesGr.next()) {
                        folderContent.push({
                            id: knowledgeBasesGr.getValue('sys_id'),
                            type: 'folder',
                            title: knowledgeBasesGr.getValue('title')
                        });
                    }
                }
                data.result = {
                    success: true,
                    results: folderContent
                };
                break;
            }
            case PROXY_TO_SERVICENOW.GET_KB_ARTICLE: {
                var knowledgeArticleGr = new GlideRecord('kb_knowledge');
                if (!knowledgeArticleGr.get(input.data.articleId)) {
                    data.result = {
                        success: true,
                        article: null
                    };
                } else {
                    var kbCategoryGr = new GlideRecord('kb_category');
                    var articleCategoryId = knowledgeArticleGr.getValue('kb_category');
                    var articleCategoryName = '';
                    if (articleCategoryId && kbCategoryGr.get(articleCategoryId)) {
                        articleCategoryName = kbCategoryGr.getValue('label');
                    }
                    data.result = {
                        success: true,
                        article: {
                            id: knowledgeArticleGr.getValue('sys_id'),
                            title: knowledgeArticleGr.getValue('short_description'),
                            keywords: [
                                knowledgeArticleGr.getValue('topic'),
                                articleCategoryName
                            ].filter(Boolean).join(' '),
                            answer: knowledgeArticleGr.getValue(knowledgeArticleGr.getValue('article_type')),
                            notes: '',
                            language: 'none',
                            createdByUser: knowledgeArticleGr.getValue('sys_created_by'),
                            lastEditedByUser: knowledgeArticleGr.getValue('sys_updated_by'),
                            customFields: {}
                        }
                    };
                }
                break;
            }
            case PROXY_TO_SERVICENOW.REQUEST_OBJECT: {
                var recordTableGr = new GlideRecord(input.data.tableName);
                if (!recordTableGr.get(input.data.sysId)) {
                    data.result = {
                        success: true,
                        article: null
                    };
                } else {
                    var table = new TableUtils(input.data.tableName);
                    var tableArrayList = table.getTables();
                    // Use the j2js method to convert the Java ArrayList to JavaScript
                    gs.include('j2js');
                    var tablesArr = j2js(tableArrayList);
                    var originTable = tablesArr[tablesArr.length - 1];

                    if (originTable === 'task') {
                        data.result = {
                            success: true,
                            recordInfo: {
                                sysId: recordTableGr.getValue('sys_id'),
                                recordType: recordTableGr.getTableName(),
                                displayName: recordTableGr.getValue('short_description')
                                    ? recordTableGr.getDisplayValue() + ': ' + recordTableGr.getValue('short_description')
                                    : recordTableGr.getDisplayValue(),
                                displayType: recordTableGr.getClassDisplayValue(),
                                refType: 'task'
                            }
                        };
                    } else if (originTable === 'sys_user') {
                        var contactDisplayId = recordTableGr.getValue('phone') ||
                            recordTableGr.getValue('mobile_phone') ||
                            recordTableGr.getValue('email');

                        data.result = {
                            success: true,
                            recordInfo: {
                                sysId: recordTableGr.getValue('sys_id'),
                                recordType: recordTableGr.getTableName(),
                                displayName: contactDisplayId
                                    ? recordTableGr.getDisplayValue() + ': ' + contactDisplayId
                                    : recordTableGr.getDisplayValue(),
                                displayType: recordTableGr.getClassDisplayValue(),
                                refType: 'contact'
                            }
                        };
                    } else {
                        data.result = {
                            success: true,
                            recordInfo: {
                                sysId: recordTableGr.getValue('sys_id'),
                                recordType: recordTableGr.getTableName(),
                                displayName: recordTableGr.getDisplayValue(),
                                displayType: recordTableGr.getClassDisplayValue(),
                                refType: 'other'
                            }
                        };
                    }
                }
                break;
            }
            case PROXY_TO_SERVICENOW.CHECK_OBJECTS_EXISTENCE: {
                var existenceData = {};
                input.data.selectedRecords.forEach(function (recordData) {
                    var recordTableGr = new GlideRecord(recordData.tableName);
                    existenceData[recordData.sysId] = !!recordTableGr.get(recordData.sysId);
                });
                data.result = {
                    success: true,
                    existenceData: existenceData
                };
                break;
            }
        }
    } catch (e) {
        data.result = {
            success: false,
            error: e
        };
    }
})();
